<?php
require_once 'config.php';
require_once 'database.php';

// بررسی نصب
$installed = file_exists('installed.lock');

if ($installed) {
    die("❌ سیستم قبلاً نصب شده است! برای نصب مجدد، فایل installed.lock را حذف کنید.");
}

$error = '';
$success = '';

if ($_POST) {
    try {
        // بررسی تنظیمات
        if (BOT_TOKEN === 'YOUR_BOT_TOKEN_HERE') {
            throw new Exception('لطفاً Bot Token را در فایل config.php تنظیم کنید');
        }
        
        if (ZARINPAL_MERCHANT_ID === 'YOUR_ZARINPAL_MERCHANT_ID') {
            throw new Exception('لطفاً Merchant ID زرین‌پال را در فایل config.php تنظیم کنید');
        }
        
        if (ADMIN_ID === 'YOUR_ADMIN_TELEGRAM_ID_HERE') {
            throw new Exception('لطفاً Admin ID را در فایل config.php تنظیم کنید');
        }
        
        // ایجاد دیتابیس
        $db = new Database();
        $db->createTables();
        
        // ایجاد فایل قفل نصب
        file_put_contents('installed.lock', date('Y-m-d H:i:s'));
        
        $success = "✅ نصب با موفقیت انجام شد!";
        
    } catch (Exception $e) {
        $error = "❌ خطا در نصب: " . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نصب ربات تلگرام - ربات سفارش ربات</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Tahoma', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .container {
            background: white;
            border-radius: 15px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            padding: 40px;
            max-width: 600px;
            width: 100%;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .header h1 {
            color: #333;
            font-size: 28px;
            margin-bottom: 10px;
        }
        
        .header p {
            color: #666;
            font-size: 16px;
        }
        
        .step {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
            border-left: 4px solid #667eea;
        }
        
        .step h3 {
            color: #333;
            margin-bottom: 10px;
        }
        
        .step p {
            color: #666;
            line-height: 1.6;
        }
        
        .step code {
            background: #e9ecef;
            padding: 2px 6px;
            border-radius: 4px;
            font-family: 'Courier New', monospace;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: bold;
        }
        
        .form-group input {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #ddd;
            border-radius: 8px;
            font-size: 16px;
        }
        
        .btn {
            width: 100%;
            padding: 15px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 18px;
            font-weight: bold;
            cursor: pointer;
            transition: transform 0.3s;
        }
        
        .btn:hover {
            transform: translateY(-2px);
        }
        
        .btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }
        
        .error {
            background: #f8d7da;
            color: #721c24;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            border: 1px solid #f5c6cb;
        }
        
        .success {
            background: #d4edda;
            color: #155724;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            border: 1px solid #c3e6cb;
        }
        
        .warning {
            background: #fff3cd;
            color: #856404;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            border: 1px solid #ffeaa7;
        }
        
        .requirements {
            background: #e7f3ff;
            border: 1px solid #b3d9ff;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
        }
        
        .requirements h4 {
            color: #0066cc;
            margin-bottom: 10px;
        }
        
        .requirements ul {
            color: #333;
            padding-right: 20px;
        }
        
        .requirements li {
            margin-bottom: 5px;
        }
        
        .checklist {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
        }
        
        .checklist h4 {
            color: #333;
            margin-bottom: 10px;
        }
        
        .checklist-item {
            display: flex;
            align-items: center;
            margin-bottom: 8px;
        }
        
        .checklist-item input[type="checkbox"] {
            margin-left: 10px;
        }
        
        .next-steps {
            background: #d4edda;
            border: 1px solid #c3e6cb;
            border-radius: 8px;
            padding: 15px;
            margin-top: 20px;
        }
        
        .next-steps h4 {
            color: #155724;
            margin-bottom: 10px;
        }
        
        .next-steps ol {
            color: #155724;
            padding-right: 20px;
        }
        
        .next-steps li {
            margin-bottom: 5px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🚀 نصب ربات تلگرام</h1>
            <p>ربات سفارش ربات - نسخه 1.0</p>
        </div>
        
        <?php if ($error): ?>
            <div class="error">
                <?php echo htmlspecialchars($error); ?>
            </div>
        <?php endif; ?>
        
        <?php if ($success): ?>
            <div class="success">
                <?php echo htmlspecialchars($success); ?>
            </div>
            
            <div class="next-steps">
                <h4>🎉 مراحل بعدی:</h4>
                <ol>
                    <li>فایل <code>installed.lock</code> را حذف کنید (برای امنیت)</li>
                    <li>ربات را در تلگرام راه‌اندازی کنید</li>
                    <li>Webhook را تنظیم کنید</li>
                    <li>پنل ادمین را تست کنید</li>
                </ol>
            </div>
        <?php else: ?>
            <div class="requirements">
                <h4>📋 پیش‌نیازها:</h4>
                <ul>
                    <li>هاست PHP با پشتیبانی از MySQL</li>
                    <li>PHP 7.4 یا بالاتر</li>
                    <li>فعال بودن cURL</li>
                    <li>دسترسی به دیتابیس MySQL</li>
                    <li>Bot Token از @BotFather</li>
                    <li>حساب زرین‌پال</li>
                </ul>
            </div>
            
            <div class="checklist">
                <h4>✅ چک‌لیست نصب:</h4>
                <div class="checklist-item">
                    <input type="checkbox" id="check1" required>
                    <label for="check1">فایل config.php را ویرایش کرده‌ام</label>
                </div>
                <div class="checklist-item">
                    <input type="checkbox" id="check2" required>
                    <label for="check2">دیتابیس MySQL ایجاد کرده‌ام</label>
                </div>
                <div class="checklist-item">
                    <input type="checkbox" id="check3" required>
                    <label for="check3">Bot Token از @BotFather دریافت کرده‌ام</label>
                </div>
                <div class="checklist-item">
                    <input type="checkbox" id="check4" required>
                    <label for="check4">Admin ID تلگرام خود را می‌دانم</label>
                </div>
                <div class="checklist-item">
                    <input type="checkbox" id="check5" required>
                    <label for="check5">Merchant ID زرین‌پال را دارم</label>
                </div>
            </div>
            
            <div class="step">
                <h3>1️⃣ تنظیمات اولیه</h3>
                <p>قبل از نصب، لطفاً فایل <code>config.php</code> را ویرایش کنید و موارد زیر را تنظیم کنید:</p>
                <ul style="margin-top: 10px; padding-right: 20px;">
                    <li><strong>BOT_TOKEN:</strong> توکن ربات از @BotFather</li>
                    <li><strong>ADMIN_ID:</strong> شناسه تلگرام شما (از @userinfobot دریافت کنید)</li>
                    <li><strong>DB_*:</strong> اطلاعات دیتابیس MySQL</li>
                    <li><strong>ZARINPAL_*:</strong> اطلاعات درگاه پرداخت زرین‌پال</li>
                    <li><strong>SITE_URL:</strong> آدرس سایت شما</li>
                </ul>
            </div>
            
            <div class="step">
                <h3>2️⃣ ایجاد دیتابیس</h3>
                <p>در پنل هاست خود، یک دیتابیس MySQL ایجاد کنید و اطلاعات آن را در فایل config.php وارد کنید.</p>
            </div>
            
            <div class="step">
                <h3>3️⃣ آپلود فایل‌ها</h3>
                <p>تمام فایل‌های پروژه را در پوشه public_html (یا www) هاست خود آپلود کنید.</p>
            </div>
            
            <div class="step">
                <h3>4️⃣ تنظیم Webhook</h3>
                <p>پس از نصب، باید Webhook ربات را تنظیم کنید:</p>
                <code>https://api.telegram.org/bot[BOT_TOKEN]/setWebhook?url=https://yourdomain.com/webhook.php</code>
            </div>
            
            <form method="POST" onsubmit="return validateChecklist()">
                <button type="submit" class="btn">🚀 شروع نصب</button>
            </form>
        <?php endif; ?>
    </div>
    
    <script>
        function validateChecklist() {
            const checkboxes = document.querySelectorAll('.checklist-item input[type="checkbox"]');
            const unchecked = Array.from(checkboxes).filter(cb => !cb.checked);
            
            if (unchecked.length > 0) {
                alert('لطفاً تمام موارد چک‌لیست را تایید کنید!');
                return false;
            }
            
            return confirm('آیا مطمئن هستید که تمام تنظیمات را انجام داده‌اید؟');
        }
    </script>
</body>
</html>
