<?php
require_once 'config.php';
require_once 'database.php';

// بررسی وجود user_id
if (!isset($_GET['user_id']) || !is_numeric($_GET['user_id'])) {
    die("❌ شناسه کاربر نامعتبر است!");
}

$user_id = (int)$_GET['user_id'];
$db = new Database();
$user = $db->getConnection()->prepare("SELECT * FROM users WHERE id = ?");
$user->execute([$user_id]);
$user = $user->fetch();

if (!$user) {
    die("❌ کاربر یافت نشد!");
}

// پردازش درخواست پرداخت
if ($_POST) {
    $amount = (int)$_POST['amount'];
    
    if ($amount < 10000) {
        $error = "حداقل مبلغ پرداخت 10,000 تومان است!";
    } else {
        // درخواست پرداخت از زرین‌پال
        $data = [
            'merchant_id' => ZARINPAL_MERCHANT_ID,
            'amount' => $amount,
            'description' => 'افزایش موجودی حساب کاربری',
            'callback_url' => ZARINPAL_CALLBACK_URL . '?user_id=' . $user_id,
            'metadata' => [
                'user_id' => $user_id,
                'telegram_id' => $user['telegram_id']
            ]
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, ZARINPAL_REQUEST_URL);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Accept: application/json'
        ]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        
        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($http_code === 200) {
            $result = json_decode($response, true);
            
            if ($result['data']['code'] == 100) {
                // ثبت تراکنش در دیتابیس
                $stmt = $db->getConnection()->prepare("
                    INSERT INTO transactions (user_id, type, amount, status, reference_id) 
                    VALUES (?, 'deposit', ?, 'pending', ?)
                ");
                $stmt->execute([$user_id, $amount, $result['data']['authority']]);
                
                // هدایت به درگاه پرداخت
                $payment_url = "https://www.zarinpal.com/pg/StartPay/" . $result['data']['authority'];
                header("Location: " . $payment_url);
                exit;
            } else {
                $error = "خطا در ایجاد درخواست پرداخت: " . $result['errors']['message'];
            }
        } else {
            $error = "خطا در ارتباط با درگاه پرداخت!";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>افزایش موجودی - ربات سفارش ربات</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Tahoma', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .container {
            background: white;
            border-radius: 15px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            padding: 40px;
            max-width: 500px;
            width: 100%;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .header h1 {
            color: #333;
            font-size: 28px;
            margin-bottom: 10px;
        }
        
        .header p {
            color: #666;
            font-size: 16px;
        }
        
        .user-info {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 30px;
            text-align: center;
        }
        
        .user-info h3 {
            color: #333;
            margin-bottom: 10px;
        }
        
        .balance {
            font-size: 24px;
            font-weight: bold;
            color: #28a745;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: bold;
        }
        
        .form-group input {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #ddd;
            border-radius: 8px;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        
        .form-group input:focus {
            outline: none;
            border-color: #667eea;
        }
        
        .amount-options {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 10px;
            margin-bottom: 20px;
        }
        
        .amount-btn {
            padding: 12px;
            border: 2px solid #ddd;
            background: white;
            border-radius: 8px;
            cursor: pointer;
            transition: all 0.3s;
            font-size: 14px;
            font-weight: bold;
        }
        
        .amount-btn:hover {
            border-color: #667eea;
            background: #f8f9fa;
        }
        
        .amount-btn.active {
            border-color: #667eea;
            background: #667eea;
            color: white;
        }
        
        .submit-btn {
            width: 100%;
            padding: 15px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 18px;
            font-weight: bold;
            cursor: pointer;
            transition: transform 0.3s;
        }
        
        .submit-btn:hover {
            transform: translateY(-2px);
        }
        
        .submit-btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }
        
        .error {
            background: #f8d7da;
            color: #721c24;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            border: 1px solid #f5c6cb;
        }
        
        .success {
            background: #d4edda;
            color: #155724;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            border: 1px solid #c3e6cb;
        }
        
        .back-link {
            text-align: center;
            margin-top: 20px;
        }
        
        .back-link a {
            color: #667eea;
            text-decoration: none;
            font-weight: bold;
        }
        
        .back-link a:hover {
            text-decoration: underline;
        }
        
        .info-box {
            background: #e7f3ff;
            border: 1px solid #b3d9ff;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
        }
        
        .info-box h4 {
            color: #0066cc;
            margin-bottom: 8px;
        }
        
        .info-box ul {
            color: #333;
            padding-right: 20px;
        }
        
        .info-box li {
            margin-bottom: 5px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>💳 افزایش موجودی</h1>
            <p>برای سفارش ربات، ابتدا موجودی خود را افزایش دهید</p>
        </div>
        
        <div class="user-info">
            <h3>👤 اطلاعات کاربر</h3>
            <p>نام: <?php echo htmlspecialchars($user['first_name'] ?? 'نامشخص'); ?></p>
            <p>موجودی فعلی: <span class="balance"><?php echo number_format($user['balance']); ?> تومان</span></p>
        </div>
        
        <?php if (isset($error)): ?>
            <div class="error">
                ❌ <?php echo htmlspecialchars($error); ?>
            </div>
        <?php endif; ?>
        
        <div class="info-box">
            <h4>ℹ️ اطلاعات مهم</h4>
            <ul>
                <li>حداقل مبلغ پرداخت: 10,000 تومان</li>
                <li>پرداخت از طریق درگاه امن زرین‌پال</li>
                <li>موجودی بلافاصله پس از پرداخت موفق اضافه می‌شود</li>
                <li>در صورت بروز مشکل، با پشتیبانی تماس بگیرید</li>
            </ul>
        </div>
        
        <form method="POST" id="paymentForm">
            <div class="form-group">
                <label for="amount">💰 مبلغ مورد نظر (تومان)</label>
                <input type="number" id="amount" name="amount" min="10000" step="1000" required>
            </div>
            
            <div class="amount-options">
                <button type="button" class="amount-btn" data-amount="50000">50,000 تومان</button>
                <button type="button" class="amount-btn" data-amount="100000">100,000 تومان</button>
                <button type="button" class="amount-btn" data-amount="200000">200,000 تومان</button>
                <button type="button" class="amount-btn" data-amount="500000">500,000 تومان</button>
            </div>
            
            <button type="submit" class="submit-btn" id="submitBtn">
                💳 پرداخت با زرین‌پال
            </button>
        </form>
        
        <div class="back-link">
            <a href="https://t.me/<?php echo BOT_TOKEN; ?>">🔙 بازگشت به ربات</a>
        </div>
    </div>
    
    <script>
        // انتخاب مبلغ از دکمه‌ها
        document.querySelectorAll('.amount-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                // حذف کلاس active از همه دکمه‌ها
                document.querySelectorAll('.amount-btn').forEach(b => b.classList.remove('active'));
                // اضافه کردن کلاس active به دکمه انتخاب شده
                this.classList.add('active');
                // تنظیم مقدار در input
                document.getElementById('amount').value = this.dataset.amount;
            });
        });
        
        // اعتبارسنجی فرم
        document.getElementById('paymentForm').addEventListener('submit', function(e) {
            const amount = document.getElementById('amount').value;
            const submitBtn = document.getElementById('submitBtn');
            
            if (amount < 10000) {
                e.preventDefault();
                alert('حداقل مبلغ پرداخت 10,000 تومان است!');
                return;
            }
            
            // غیرفعال کردن دکمه برای جلوگیری از ارسال مکرر
            submitBtn.disabled = true;
            submitBtn.textContent = 'در حال پردازش...';
        });
        
        // تنظیم مقدار پیش‌فرض
        document.getElementById('amount').value = '50000';
        document.querySelector('.amount-btn[data-amount="50000"]').classList.add('active');
    </script>
</body>
</html>
