<?php
require_once 'config.php';

// بررسی دسترسی ادمین
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    die("❌ دسترسی غیرمجاز! لطفاً ابتدا وارد شوید.");
}

echo "🔄 بازیابی پشتیبان سیستم ربات تلگرام\n";
echo "====================================\n\n";

$backup_dir = 'backups/';

if (!file_exists($backup_dir)) {
    echo "❌ پوشه پشتیبان‌گیری یافت نشد!\n";
    exit;
}

// لیست فایل‌های پشتیبان
$backup_files = glob($backup_dir . 'backup_*.sql*');
if (empty($backup_files)) {
    echo "❌ هیچ فایل پشتیبان‌گیری یافت نشد!\n";
    exit;
}

// مرتب‌سازی بر اساس تاریخ (جدیدترین اول)
rsort($backup_files);

echo "📁 فایل‌های پشتیبان موجود:\n";
echo "==========================\n";
foreach ($backup_files as $index => $file) {
    $file_size = filesize($file);
    $file_date = date('Y/m/d H:i:s', filemtime($file));
    $file_name = basename($file);
    echo ($index + 1) . ". $file_name - $file_date - " . number_format($file_size) . " بایت\n";
}
echo "\n";

// انتخاب فایل پشتیبان
if (isset($_POST['backup_file'])) {
    $selected_file = $_POST['backup_file'];
    
    if (!file_exists($selected_file)) {
        echo "❌ فایل انتخاب شده یافت نشد!\n";
        exit;
    }
    
    echo "📄 فایل انتخاب شده: " . basename($selected_file) . "\n";
    echo "📅 تاریخ: " . date('Y/m/d H:i:s', filemtime($selected_file)) . "\n";
    echo "📏 حجم: " . number_format(filesize($selected_file)) . " بایت\n\n";
    
    // بررسی تایید
    if (isset($_POST['confirm']) && $_POST['confirm'] === 'yes') {
        echo "🔄 شروع بازیابی...\n";
        
        try {
            // اتصال به دیتابیس
            $pdo = new PDO(
                "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
                DB_USER,
                DB_PASS,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
                ]
            );
            
            echo "1️⃣ اتصال به دیتابیس...\n";
            echo "✅ اتصال موفق\n\n";
            
            // خواندن فایل پشتیبان
            echo "2️⃣ خواندن فایل پشتیبان...\n";
            
            // بررسی نوع فایل (فشرده یا عادی)
            if (substr($selected_file, -3) === '.gz') {
                echo "📦 فایل فشرده تشخیص داده شد\n";
                $backup_content = gzfile($selected_file);
                $backup_content = implode('', $backup_content);
            } else {
                $backup_content = file_get_contents($selected_file);
            }
            
            if ($backup_content === false) {
                throw new Exception("خطا در خواندن فایل پشتیبان");
            }
            
            echo "✅ فایل خوانده شد\n\n";
            
            // پاک کردن جداول موجود
            echo "3️⃣ پاک کردن جداول موجود...\n";
            $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
            foreach ($tables as $table) {
                $pdo->exec("DROP TABLE IF EXISTS `$table`");
                echo "   🗑️ جدول $table حذف شد\n";
            }
            echo "✅ جداول پاک شدند\n\n";
            
            // اجرای فایل پشتیبان
            echo "4️⃣ اجرای فایل پشتیبان...\n";
            
            // تقسیم فایل به دستورات SQL
            $statements = explode(';', $backup_content);
            $executed_statements = 0;
            
            foreach ($statements as $statement) {
                $statement = trim($statement);
                if (empty($statement) || strpos($statement, '--') === 0) {
                    continue;
                }
                
                try {
                    $pdo->exec($statement);
                    $executed_statements++;
                    
                    if ($executed_statements % 10 === 0) {
                        echo "   📊 $executed_statements دستور اجرا شد\n";
                    }
                } catch (Exception $e) {
                    echo "   ⚠️ خطا در اجرای دستور: " . substr($statement, 0, 50) . "...\n";
                }
            }
            
            echo "✅ $executed_statements دستور SQL اجرا شد\n\n";
            
            // بررسی نتیجه
            echo "5️⃣ بررسی نتیجه...\n";
            $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
            echo "📊 تعداد جداول بازیابی شده: " . count($tables) . "\n";
            
            foreach ($tables as $table) {
                $count = $pdo->query("SELECT COUNT(*) FROM `$table`")->fetchColumn();
                echo "   📄 $table: $count رکورد\n";
            }
            echo "\n";
            
            echo "✅ بازیابی با موفقیت انجام شد!\n";
            echo "🎉 سیستم آماده استفاده است.\n";
            
        } catch (Exception $e) {
            echo "❌ خطا در بازیابی: " . $e->getMessage() . "\n";
        }
        
    } else {
        // نمایش فرم تایید
        ?>
        <!DOCTYPE html>
        <html lang="fa" dir="rtl">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>تایید بازیابی پشتیبان</title>
            <style>
                body { font-family: Tahoma, sans-serif; background: #f5f5f5; padding: 20px; }
                .container { max-width: 600px; margin: 0 auto; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
                .warning { background: #fff3cd; color: #856404; padding: 15px; border-radius: 5px; margin: 20px 0; border: 1px solid #ffeaa7; }
                .btn { background: #dc3545; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; margin: 5px; }
                .btn:hover { background: #c82333; }
                .btn-secondary { background: #6c757d; }
                .btn-secondary:hover { background: #5a6268; }
            </style>
        </head>
        <body>
            <div class="container">
                <h2>⚠️ تایید بازیابی پشتیبان</h2>
                <div class="warning">
                    <strong>هشدار:</strong> این عملیات تمام داده‌های فعلی را پاک کرده و با داده‌های پشتیبان جایگزین می‌کند!
                </div>
                <p><strong>فایل انتخاب شده:</strong> <?php echo basename($selected_file); ?></p>
                <p><strong>تاریخ:</strong> <?php echo date('Y/m/d H:i:s', filemtime($selected_file)); ?></p>
                <p><strong>حجم:</strong> <?php echo number_format(filesize($selected_file)); ?> بایت</p>
                
                <form method="POST">
                    <input type="hidden" name="backup_file" value="<?php echo htmlspecialchars($selected_file); ?>">
                    <input type="hidden" name="confirm" value="yes">
                    <button type="submit" class="btn">✅ تایید و ادامه</button>
                    <a href="restore.php" class="btn btn-secondary">❌ لغو</a>
                </form>
            </div>
        </body>
        </html>
        <?php
        exit;
    }
    
} else {
    // نمایش فرم انتخاب فایل
    ?>
    <!DOCTYPE html>
    <html lang="fa" dir="rtl">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>بازیابی پشتیبان</title>
        <style>
            body { font-family: Tahoma, sans-serif; background: #f5f5f5; padding: 20px; }
            .container { max-width: 800px; margin: 0 auto; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
            .backup-list { margin: 20px 0; }
            .backup-item { background: #f8f9fa; padding: 15px; margin: 10px 0; border-radius: 5px; border: 1px solid #dee2e6; }
            .backup-item:hover { background: #e9ecef; }
            .backup-item input[type="radio"] { margin-left: 10px; }
            .btn { background: #007bff; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; margin: 5px; }
            .btn:hover { background: #0056b3; }
            .btn:disabled { background: #6c757d; cursor: not-allowed; }
        </style>
    </head>
    <body>
        <div class="container">
            <h2>🔄 بازیابی پشتیبان</h2>
            <p>لطفاً فایل پشتیبان مورد نظر را انتخاب کنید:</p>
            
            <form method="POST" id="restoreForm">
                <div class="backup-list">
                    <?php foreach ($backup_files as $index => $file): ?>
                        <div class="backup-item">
                            <input type="radio" name="backup_file" value="<?php echo htmlspecialchars($file); ?>" id="backup_<?php echo $index; ?>" required>
                            <label for="backup_<?php echo $index; ?>">
                                <strong><?php echo basename($file); ?></strong><br>
                                <small>تاریخ: <?php echo date('Y/m/d H:i:s', filemtime($file)); ?> - حجم: <?php echo number_format(filesize($file)); ?> بایت</small>
                            </label>
                        </div>
                    <?php endforeach; ?>
                </div>
                
                <button type="submit" class="btn" id="restoreBtn" disabled>بازیابی</button>
                <a href="admin.php" class="btn" style="background: #6c757d; text-decoration: none;">بازگشت</a>
            </form>
        </div>
        
        <script>
            document.querySelectorAll('input[name="backup_file"]').forEach(radio => {
                radio.addEventListener('change', function() {
                    document.getElementById('restoreBtn').disabled = false;
                });
            });
            
            document.getElementById('restoreForm').addEventListener('submit', function(e) {
                if (!confirm('آیا مطمئن هستید که می‌خواهید بازیابی را انجام دهید؟ این عملیات غیرقابل بازگشت است!')) {
                    e.preventDefault();
                }
            });
        </script>
    </body>
    </html>
    <?php
}
?>
