<?php
// بررسی امنیت سیستم
echo "🔒 بررسی امنیت سیستم ربات تلگرام\n";
echo "==================================\n\n";

// بررسی فایل‌های حساس
echo "1️⃣ بررسی فایل‌های حساس...\n";
$sensitive_files = [
    'config.php' => 'تنظیمات اصلی',
    'database.php' => 'کلاس دیتابیس',
    'telegram_bot.php' => 'کلاس ربات',
    'installed.lock' => 'فایل قفل نصب'
];

foreach ($sensitive_files as $file => $description) {
    if (file_exists($file)) {
        $permissions = substr(sprintf('%o', fileperms($file)), -4);
        echo "✅ $file ($description) - مجوزها: $permissions\n";
        
        // بررسی دسترسی عمومی
        if (is_readable($file) && $permissions[3] != '0') {
            echo "⚠️ هشدار: $file قابل خواندن توسط عموم است!\n";
        }
    } else {
        echo "❌ $file ($description) - فایل یافت نشد\n";
    }
}
echo "\n";

// بررسی تنظیمات PHP
echo "2️⃣ بررسی تنظیمات PHP...\n";
$php_settings = [
    'display_errors' => ini_get('display_errors'),
    'log_errors' => ini_get('log_errors'),
    'error_reporting' => ini_get('error_reporting'),
    'expose_php' => ini_get('expose_php'),
    'allow_url_fopen' => ini_get('allow_url_fopen'),
    'allow_url_include' => ini_get('allow_url_include')
];

foreach ($php_settings as $setting => $value) {
    $status = '';
    switch ($setting) {
        case 'display_errors':
            $status = $value ? '❌ خطرناک' : '✅ امن';
            break;
        case 'log_errors':
            $status = $value ? '✅ فعال' : '⚠️ غیرفعال';
            break;
        case 'expose_php':
            $status = $value ? '❌ خطرناک' : '✅ امن';
            break;
        case 'allow_url_include':
            $status = $value ? '❌ خطرناک' : '✅ امن';
            break;
        default:
            $status = 'ℹ️ ' . ($value ? 'فعال' : 'غیرفعال');
    }
    echo "$status $setting: " . ($value ? 'فعال' : 'غیرفعال') . "\n";
}
echo "\n";

// بررسی فایل .htaccess
echo "3️⃣ بررسی فایل .htaccess...\n";
if (file_exists('.htaccess')) {
    echo "✅ فایل .htaccess موجود است\n";
    
    $htaccess_content = file_get_contents('.htaccess');
    $security_rules = [
        'Order Allow,Deny' => 'قوانین دسترسی',
        'Deny from all' => 'مسدود کردن دسترسی',
        'Header always set' => 'تنظیمات امنیتی HTTP',
        'RewriteEngine On' => 'فعال‌سازی Rewrite',
        'Options -Indexes' => 'غیرفعال کردن لیست پوشه‌ها'
    ];
    
    foreach ($security_rules as $rule => $description) {
        if (strpos($htaccess_content, $rule) !== false) {
            echo "✅ $description\n";
        } else {
            echo "⚠️ $description - یافت نشد\n";
        }
    }
} else {
    echo "❌ فایل .htaccess یافت نشد - امنیت کاهش یافته!\n";
}
echo "\n";

// بررسی مجوزهای فایل‌ها
echo "4️⃣ بررسی مجوزهای فایل‌ها...\n";
$important_files = [
    'webhook.php',
    'payment.php',
    'callback.php',
    'admin.php'
];

foreach ($important_files as $file) {
    if (file_exists($file)) {
        $permissions = substr(sprintf('%o', fileperms($file)), -4);
        echo "📄 $file - مجوزها: $permissions\n";
        
        if ($permissions[3] != '0') {
            echo "⚠️ هشدار: $file قابل اجرا توسط عموم است!\n";
        }
    }
}
echo "\n";

// بررسی تنظیمات دیتابیس
echo "5️⃣ بررسی تنظیمات دیتابیس...\n";
if (file_exists('config.php')) {
    $config_content = file_get_contents('config.php');
    
    $db_security_checks = [
        'PDO::ATTR_ERRMODE' => 'تنظیمات خطای PDO',
        'PDO::ATTR_EMULATE_PREPARES' => 'غیرفعال کردن Prepared Statements تقلبی',
        'charset=utf8mb4' => 'تنظیم charset امن'
    ];
    
    foreach ($db_security_checks as $check => $description) {
        if (strpos($config_content, $check) !== false) {
            echo "✅ $description\n";
        } else {
            echo "⚠️ $description - یافت نشد\n";
        }
    }
} else {
    echo "❌ فایل config.php یافت نشد\n";
}
echo "\n";

// بررسی فایل‌های نصب
echo "6️⃣ بررسی فایل‌های نصب...\n";
$install_files = ['install.php', 'setup_webhook.php', 'test_system.php'];
foreach ($install_files as $file) {
    if (file_exists($file)) {
        echo "⚠️ $file - باید پس از نصب حذف شود\n";
    }
}
echo "\n";

// پیشنهادات امنیتی
echo "7️⃣ پیشنهادات امنیتی...\n";
echo "=====================\n";
echo "🔐 تغییر رمز عبور ادمین در admin.php\n";
echo "🗑️ حذف فایل‌های نصب پس از تکمیل\n";
echo "🔒 تنظیم مجوزهای فایل‌ها به 644\n";
echo "📁 تنظیم مجوزهای پوشه‌ها به 755\n";
echo "🛡️ فعال‌سازی SSL/HTTPS\n";
echo "📊 نظارت منظم بر لاگ‌ها\n";
echo "🔄 به‌روزرسانی منظم سیستم\n";
echo "🚫 مسدود کردن IP های مشکوک\n";
echo "\n";

// نتیجه نهایی
echo "🎯 نتیجه بررسی امنیت:\n";
echo "====================\n";

$security_score = 0;
$total_checks = 0;

// محاسبه امتیاز امنیت
if (file_exists('.htaccess')) $security_score++;
$total_checks++;

if (ini_get('display_errors') == 0) $security_score++;
$total_checks++;

if (ini_get('expose_php') == 0) $security_score++;
$total_checks++;

if (ini_get('allow_url_include') == 0) $security_score++;
$total_checks++;

$security_percentage = ($security_score / $total_checks) * 100;

if ($security_percentage >= 80) {
    echo "✅ امنیت سیستم خوب است ($security_percentage%)\n";
} elseif ($security_percentage >= 60) {
    echo "⚠️ امنیت سیستم متوسط است ($security_percentage%)\n";
} else {
    echo "❌ امنیت سیستم ضعیف است ($security_percentage%)\n";
}

echo "\n🏁 بررسی امنیت تمام شد!\n";
?>
