<?php
require_once 'config.php';
require_once 'database.php';

// بررسی نصب سیستم
if (!file_exists('installed.lock')) {
    die("❌ سیستم نصب نشده است! ابتدا install.php را اجرا کنید.");
}

echo "🧪 تست سیستم ربات تلگرام\n";
echo "========================\n\n";

$db = new Database();
$conn = $db->getConnection();

// تست اتصال دیتابیس
echo "1️⃣ تست اتصال دیتابیس...\n";
try {
    $result = $conn->query("SELECT 1");
    echo "✅ اتصال دیتابیس موفق\n\n";
} catch (Exception $e) {
    echo "❌ خطا در اتصال دیتابیس: " . $e->getMessage() . "\n\n";
    exit;
}

// تست جداول
echo "2️⃣ تست جداول دیتابیس...\n";
$tables = ['users', 'transactions', 'orders', 'consultations', 'logs'];
foreach ($tables as $table) {
    try {
        $result = $conn->query("SELECT COUNT(*) FROM $table");
        $count = $result->fetchColumn();
        echo "✅ جدول $table: $count رکورد\n";
    } catch (Exception $e) {
        echo "❌ خطا در جدول $table: " . $e->getMessage() . "\n";
    }
}
echo "\n";

// تست تنظیمات
echo "3️⃣ تست تنظیمات...\n";
$config_tests = [
    'BOT_TOKEN' => BOT_TOKEN !== 'YOUR_BOT_TOKEN_HERE',
    'ADMIN_ID' => ADMIN_ID !== 'YOUR_ADMIN_TELEGRAM_ID_HERE',
    'ZARINPAL_MERCHANT_ID' => ZARINPAL_MERCHANT_ID !== 'YOUR_ZARINPAL_MERCHANT_ID',
    'SITE_URL' => SITE_URL !== 'https://yourdomain.com'
];

foreach ($config_tests as $config => $status) {
    echo ($status ? "✅" : "❌") . " $config\n";
}
echo "\n";

// تست API تلگرام
echo "4️⃣ تست API تلگرام...\n";
if (BOT_TOKEN !== 'YOUR_BOT_TOKEN_HERE') {
    $api_url = "https://api.telegram.org/bot" . BOT_TOKEN . "/getMe";
    $response = file_get_contents($api_url);
    $result = json_decode($response, true);
    
    if ($result['ok']) {
        echo "✅ ربات فعال: " . $result['result']['first_name'] . " (@" . $result['result']['username'] . ")\n";
    } else {
        echo "❌ خطا در API تلگرام: " . $result['description'] . "\n";
    }
} else {
    echo "❌ Bot Token تنظیم نشده\n";
}
echo "\n";

// تست Webhook
echo "5️⃣ تست Webhook...\n";
if (BOT_TOKEN !== 'YOUR_BOT_TOKEN_HERE') {
    $webhook_url = "https://api.telegram.org/bot" . BOT_TOKEN . "/getWebhookInfo";
    $response = file_get_contents($webhook_url);
    $result = json_decode($response, true);
    
    if ($result['ok']) {
        $webhook = $result['result'];
        echo "✅ Webhook URL: " . ($webhook['url'] ?: 'تنظیم نشده') . "\n";
        echo "📊 پیام‌های در انتظار: " . $webhook['pending_update_count'] . "\n";
        if ($webhook['last_error_message']) {
            echo "⚠️ آخرین خطا: " . $webhook['last_error_message'] . "\n";
        }
    } else {
        echo "❌ خطا در دریافت اطلاعات Webhook\n";
    }
} else {
    echo "❌ Bot Token تنظیم نشده\n";
}
echo "\n";

// تست زرین‌پال
echo "6️⃣ تست درگاه زرین‌پال...\n";
if (ZARINPAL_MERCHANT_ID !== 'YOUR_ZARINPAL_MERCHANT_ID') {
    echo "✅ Merchant ID تنظیم شده\n";
} else {
    echo "❌ Merchant ID تنظیم نشده\n";
}
echo "\n";

// آمار کلی
echo "7️⃣ آمار کلی سیستم...\n";
try {
    $stats = [
        'users' => $conn->query("SELECT COUNT(*) FROM users")->fetchColumn(),
        'transactions' => $conn->query("SELECT COUNT(*) FROM transactions")->fetchColumn(),
        'orders' => $conn->query("SELECT COUNT(*) FROM orders")->fetchColumn(),
        'consultations' => $conn->query("SELECT COUNT(*) FROM consultations")->fetchColumn(),
        'logs' => $conn->query("SELECT COUNT(*) FROM logs")->fetchColumn()
    ];
    
    foreach ($stats as $table => $count) {
        echo "📊 $table: $count رکورد\n";
    }
} catch (Exception $e) {
    echo "❌ خطا در دریافت آمار: " . $e->getMessage() . "\n";
}
echo "\n";

// تست فایل‌های مهم
echo "8️⃣ تست فایل‌های مهم...\n";
$important_files = [
    'webhook.php' => 'پردازش Webhook',
    'payment.php' => 'صفحه پرداخت',
    'callback.php' => 'Callback زرین‌پال',
    'admin.php' => 'پنل ادمین'
];

foreach ($important_files as $file => $description) {
    if (file_exists($file)) {
        echo "✅ $file ($description)\n";
    } else {
        echo "❌ $file ($description) - فایل یافت نشد\n";
    }
}
echo "\n";

// نتیجه نهایی
echo "🎯 نتیجه تست:\n";
echo "=============\n";

$all_tests_passed = true;
if (BOT_TOKEN === 'YOUR_BOT_TOKEN_HERE') $all_tests_passed = false;
if (ADMIN_ID === 'YOUR_ADMIN_TELEGRAM_ID_HERE') $all_tests_passed = false;
if (ZARINPAL_MERCHANT_ID === 'YOUR_ZARINPAL_MERCHANT_ID') $all_tests_passed = false;
if (SITE_URL === 'https://yourdomain.com') $all_tests_passed = false;

if ($all_tests_passed) {
    echo "✅ سیستم آماده استفاده است!\n";
    echo "🔗 لینک ربات: https://t.me/" . (json_decode(file_get_contents("https://api.telegram.org/bot" . BOT_TOKEN . "/getMe"), true)['result']['username'] ?? 'نامشخص') . "\n";
    echo "🛠️ پنل ادمین: " . SITE_URL . "/admin.php\n";
} else {
    echo "❌ سیستم نیاز به تنظیمات بیشتری دارد!\n";
    echo "📝 لطفاً فایل config.php را کامل کنید.\n";
}

echo "\n🏁 تست تمام شد!\n";
?>
